namespace eval flist {

namespace export Show w lasttag showdir

proc Show {w} {
	global lasttag
	set lasttag ""
	showdir $w "*"
	return $w
}

proc showitem {w index type text} {
	global c
	set f [file split $text]
	set f [lindex $f [expr [llength $f]-1]]
	$w create text  20 [expr $index*15+5] -text $f -tag "1_$index" -anchor nw -fill $c(color-listtext)
	$w create image 10 [expr $index*15+10] -image $type -tag "2_$index"
	$w bind "1_$index" <Double-Button-1> "flist::dclick $w {$text}"
	$w bind "2_$index" <Double-Button-1> "flist::dclick $w {$text}"
	$w bind "1_$index" <Button-1> "flist::click $w 1_$index {$text}"
	$w bind "1_$index" <Button-3> "flist::click $w 1_$index {$text}"
	$w bind "2_$index" <Button-1> "flist::click $w 1_$index {$text}"
	$w bind "2_$index" <Button-3> "flist::click $w 1_$index {$text}"
}

proc showlist {w list typelist} {
	set i 0
	$w delete all
	for {set i 0} {$i <[llength $list]} {incr i } {
		showitem $w $i [lindex $typelist $i] [lindex $list $i]
	}
}

proc mark {w tag} {
	global lasttag c
	set y [expr [lindex [$w coords $tag] 1]-2]
	if {$y>=0} {
		$w itemconfigure "{$lasttag}" -fill $c(color-listtext)
		$w delete marking
		$w create rectangle 1 $y 800 [expr $y+15] -tag marking -fill $c(color-listactivebg) -outline $c(color-listactivebg)
		$w lower marking
		$w itemconfigure "{$tag}" -fill $c(color-listactivetext)
		set lasttag $tag
	}
}

proc click {w tag file} {
	global flist_lastfile
	set flist_lastfile $file
	mark $w "$tag"
}


proc dclick {w file} {
	if {$file==".."} {
		cd ..
		showdir $w *
		} else {
		if {[file isdir "$file"]} {
			cd "$file"
			showdir $w *
		} else {
		flist::open $file
		}
	}
}
 
proc showdir {w path} {
	global current_window window

	set typs ""
	set openlist [win::pathnames]

	set list [glob -nocomplain $path]

	for {set i 0} {$i <[llength $list]} {incr i } {
		set f [lindex $list $i]

		if {[file isdir $f]} {
			set typs "$typs i_folder"
		} else {
			set pos [lsearch $openlist [file join [pwd] $f]]
			if {$pos==-1} {
				set typs "$typs i_file"
			} else {
				if {$window([expr $pos +1],change)==0} { 
					set typs "$typs i_savedfile" 
				} else { 
					set typs "$typs i_openfile"
				}
			}	
		}
	}
	set list [concat ".. $list"]
	set typs "i_folder $typs"

	showlist $w "$list" $typs
	$w configure -scrollregion "0 0 200 [expr 15*[llength $list]]"
}


proc copy {file} {
	set f  [file join [pwd] $file]
	txt::copyfrom_clip .text $f
}

proc open {file} {
	set f  [file join [pwd] $file]

	set n [lsearch [win::pathnames]  $f ]

	if {$n=="-1"} {
		file::Load "file {$f}" -force
	} else {
		win::activate [lindex [win::names] $n ]
	}
}

proc delete {file} {

	set r [xdialog -icon warn -title "Delete ?" -message "Are you sure you want to delete \042$file\042 ?" -buttons "Delete Cancel" -default 0 ]

	if {$r=="Delete"} {
		set f  [file join [pwd] $file]
		file delete $f -force
		flist::showdir .flist "[pwd]/*"
	}
}

}

set flist_lastfile ""

set menu .fmnu
menu $menu -tearoff 0
$menu add command -label "Open" -command {global flist_file;flist::dclick .flist $flist_lastfile}
$menu add command -label "Copy" -command {global flist_file;flist::copy $flist_lastfile}
$menu add separator
$menu add command -label "Delete" -command {global flist_file;flist::delete $flist_lastfile}
