#?-Mouse
#?
#? %2Popup menus:%
#? Push right button anywhere in the text box and the "Edit" menu will appear.
#? Push right button + shift and the Search menu will appear.
#?
#? %2Mark text%
#? Push the left button at the begining of the text you want to mark, move
#? the cursor to the end of the text you want to mark and release the button.
#?
#? Doubble clicking in the text will mark a whole word.
#? Tripple clicking in the text will mark a whole line.
#?
#? %2Wheel mouse ?%
#?
#? TCltextEdit is prepared for wheel mouse but it must be enabled in X
#?
#? This is how I did it, but I cant garantee that it will work for you.
#? I have a Logitech wheelmouse, and I use XFree86 Version 3.3.2.3.
#? 
#? This goes in to XF86Config under Section "Pointer"
#?
#?    Protocol    "intellimouse"
#?    Device      "/dev/mouse"
#?    ZAxisMapping 4 5
#?
#? Do not fiddle with these parameters if you're not sure of what you're doing.
#?
#?-StatusLine
#?
#? This is the status line, it is located just beneith the "text window"
#?
#? #1 Changed or Unchanged, Tells you if your text is saved or not.
#? #2 Indicates which line the cursor is positioned at, [row.column].
#? #3 The full name of the file in the active window.
#? #4 Status text, tells you important information about the editor.
#? #5 Push the left or right mouse button and rezise the window.
#?
#? %Pstatus.gif%
#?
#?-Macro-Dialog
#?  
#? usage: Dialog name inputname 
#?
#? The built in macro displays a general dialog.
#?
#? %Pdlg.gif%
#?
#? Return: 
#? If the ok button is pressed the text in the input box is returned
#? otherwise *cancel is returned.
#?
#? %2Example%2
#?
#? Dialog "TestDlg" "Enter your name: "
#?
#? Related topics: %lMacros%
#?
#?-xdialog
#?
#? %2xdialog%
#?
#? A standard dialog.
#? 
#? %fBlue%Usage: xdialog [options]......%fblack%
#?
#? -icon		(image)	A valid  image created with "image create photo ...".
#? -default		(number)	Which button that should be focused by default.
#? -buttons		(list)	A list of buttons that should appear in the window.
#? -title		(string)	Text that should appear in the title bar of the window.
#? -message	(string)	Text that should appear next to the icon
#?


#--------------------- Widgets & Defaults ----------------------------
option add *Scrollbar.width         12 widgetDefault
option add *Scrollbar.borderWidth   1  widgetDefault

proc xbutton {w args} {
c
eval "button $w $args -borderwidth 1 -foreground black"
}

proc xentry {w args} {
global c
c
eval "entry $w $args -background $c(color-editbg) -foreground $c(color-edittxt) -borderwidth 1"
}

proc xmenu {w args} {
global c
c
eval "menu $w $args -tearoff $c(tearoff) -background $c(color-menubg) -foreground $c(color-menutxt) -activebackground $c(color-menuactive) -activeforeground $c(color-menuactivetext) -borderwidth 1 -activeborderwidth 0"
}

proc xdialog {args} {
	global result
	set wfocus ""

	if {[set i [lsearch -exact $args "-default"]] >= 0} {
		set default [lindex $args [expr $i+1]]
	} else { set default "none" }

	if {[set i [lsearch -exact $args "-icon"]] >= 0} {
		set icon [lindex $args [expr $i+1]]
	} else { set icon "" }

	if {[set i [lsearch -exact $args "-buttons"]] >= 0} {
		set buttons [lindex $args [expr $i+1]]
	} else { set buttons "Yes No" }

	if {[set i [lsearch -exact $args "-title"]] >= 0} {
		set title [lindex $args [expr $i+1]]
	} else { set title "?" }

	if {[set i [lsearch -exact $args "-message"]] >= 0} {
		set message [lindex $args [expr $i+1]]
	} else { set message "Are you sure ?" }

	set w .wdlg
	catch {destroy $w}
	toplevel $w

	wm protocol  $w WM_DELETE_WINDOW "set result -" 
	wm title $w $title
	wm iconbitmap $w ""
	wm resizable $w false false
	wm transient $w .
	set result "-"

	frame $w.frame 
	label $w.frame.label -text $message -wraplength 200

	pack $w.frame.label -fill y

	if {[llength $buttons]==1} {
		set b $buttons
		label $w.frame.a -width 5
		xbutton $w.frame.b -text $b -command "set result $b" -width 5 -underline 0
		bind $w <[string tolower [string range $b 0 0]]> "set result $b"
		bind $w <[string toupper [string range $b 0 0]]> "set result $b"
		label $w.frame.c -width 5
		pack $w.frame.a  $w.frame.b $w.frame.c -side left -padx 10
		set wfocus "$w.frame.b"
	}
	
	if {[llength $buttons]==2} {
		set b [lindex $buttons 0]
		xbutton $w.frame.a -text $b -command "set result $b" -width 5 -underline 0
		bind $w <[string tolower [string range $b 0 0]]> "set result $b"
		bind $w <[string toupper [string range $b 0 0]]> "set result $b"
		label $w.frame.b -width 5
		set b [lindex $buttons 1]
		xbutton $w.frame.c -text $b -command "set result $b" -width 5 -underline 0
		bind $w <[string tolower [string range $b 0 0]]> "set result $b"
		bind $w <[string toupper [string range $b 0 0]]> "set result $b"
		pack $w.frame.a  $w.frame.b $w.frame.c -side left -padx 10
		if {$default==0} { 	set wfocus "$w.frame.a" } 
		if {$default==1} { 	set wfocus "$w.frame.c" }
		if {$default=="none"} { set	wfocus "$w.frame" }		
	}

	if {[llength $buttons]>2} {
		foreach b $buttons {
			xbutton $w.frame.[string tolower $b] -text $b -command "set result $b" -width 5 -underline 0
			pack $w.frame.[string tolower $b] -side left -padx 10
			bind $w <[string tolower [string range $b 0 0]]> "set result $b"
			bind $w <[string toupper [string range $b 0 0]]> "set result $b"
		}
		if {$default!="none"} {
			set wfocus "$w.frame.[string tolower [lindex $buttons $default]]"
		} else {
			set wfocus "$w.frame"
		}
	}

	bind $w <Escape> "set result -"

	if {$icon!=""} {
		label $w.img -image $icon 
		pack $w.img $w.frame -side left 
	} else {
		pack $w.frame -side left 
	}

	powin $w
	grab $w
	if {$wfocus!=""} {focus -force $wfocus }

	vwait result
	destroy $w
	if {$result=="-"} { set result "" }
	return $result
}

#----------------------------------------------------------
proc Dialog {name inputname} {
global r

set dlg .dlg
catch {destroy $dlg}
toplevel $dlg
wm title $dlg $name

frame $dlg.input
label $dlg.input.label -text $inputname
xentry $dlg.input.entry -width 20 -textvariable entrytext
pack $dlg.input.label $dlg.input.entry -side left

frame $dlg.buttons
xbutton $dlg.buttons.ok -text "Ok" -width 5 -command "set r ok"
xbutton $dlg.buttons.cancel -text "Cancel" -width 5 -command "set r *cancel"
pack $dlg.buttons.ok $dlg.buttons.cancel -pady 5

pack $dlg.input $dlg.buttons -side left -padx 5

powin $dlg
vwait r
if {$r=="ok"} {set r [$dlg.input.entry get] }
destroy $dlg
return $r
}
#------------------------ Flist procedure -----------------
proc doflist {act} {
global c flistw
if {$act==1} {
frame .hz -relief raised -borderwidth 1 -cursor sb_h_double_arrow -width 4

canvas .flist -background $c(color-listbg) -width $c(flist-width) -borderwidth 1 -relief sunken -xscrollcommand ".fscrollx set" -yscrollcommand ".fscrolly set"
flist::Show .flist 
scrollbar .fscrollx -command ".flist xview" -orient horiz -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg)
scrollbar .fscrolly -command ".flist yview" -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg)
entry .path -borderwidth 1 -width 1

grid .path     -column 0 -row 1 -sticky nsew 
grid .flist    -column 0 -row 2 -sticky nsew
grid .fscrollx -column 0 -row 3 -sticky ew
grid .fscrolly -column 1 -row 1 -sticky ns -rowspan 2
grid .hz       -column 2 -row 1 -sticky ns -rowspan 2
grid .text     -column 3 -row 1 -sticky nsew -rowspan 2 -columnspan 2
grid .scrolly -column 4 -row 1 -sticky ns -rowspan 2
grid .scrollx -column 3 -row 3 -sticky ew -columnspan 1

grid rowconfigure . 2 -weight 3
grid columnconfigure . 0 -weight 0
grid columnconfigure . 1 -weight 0
grid columnconfigure . 2 -weight 0
grid columnconfigure . 3 -weight 1
grid columnconfigure . 4 -weight 0

set flistw ""

bind .hz <Button-1> {
global flistw flistow
%W configure -background $c(color-menuactive)
set flistw %X
set flistow  [expr [winfo width .flist]-4]
}

bind .hz <ButtonRelease> {
global flistw
set flistw ""
%W configure -background $c(color-background)
}

bind .hz <Enter> " %W configure -background $c(color-menuactive) "
bind .hz <Leave> " %W configure -background $c(color-background) "

bind .hz  <Motion> {
global flistw flistow c
if {$flistw!=""} {
	set w [expr $flistow + (%X - $flistw)]
	if {$w>0} { 
	.flist configure -width $w 
	set c(flist-width) $w
	}
 	}
}

bind .path <Return> {
cd [%W get]
flist::showdir .flist *
}

bind .flist <Button-3> {.fmnu post [winfo pointerx . ] [winfo pointery .]}
bind .flist <Button-1> {.fmnu unpost}

} else {
destroy .flist
destroy .fscrolly
destroy .fscrollx
destroy .path
destroy .hz

grid .scrollx -column 0 -row 3 -sticky ew -columnspan 3
grid .text    -column 0 -row 1 -sticky nsew -columnspan 3
grid rowconfigure . 2 -weight 3
grid columnconfigure . 3 -weight 0
grid columnconfigure . 1 -weight 2

}
}
#--------------------------- text shell -------------------
proc dotextshell {act} {
global c textshh

if {$act==1} {
c "Activate textshell"

frame .wz -relief raised -borderwidth 1 -cursor sb_v_double_arrow -height 4
text .textshell -height $c(textshell-height)  -yscrollcommand ".shscrolly set" -xscrollcommand ".shscrollx set" \
-wrap none -foreground $c(color-textshellfg) -background $c(color-textshellbg) \
-insertbackground $c(color-textshellcursor) -insertborderwidth 0 -insertwidth 6 \
-font $c(font-textshell) -borderwidth 1 -highlightthickness 0


scrollbar .shscrolly -command ".textshell yview" -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg) 
scrollbar .shscrollx -command ".textshell xview" -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg) -orient horiz

grid .scrolly   -column 4 -row 1 -sticky ns -rowspan 2
grid .wz        -column 0 -row 5 -sticky ew -columnspan 4
grid .textshell -column 0 -row 6 -sticky ew -columnspan 4
grid .shscrolly -column 4 -row 6 -sticky ns
grid .shscrollx -column 0 -row 7 -sticky ew -columnspan 4
grid .status    -column 0 -row 8 -sticky ew -columnspan 5

grid rowconfigure . 5 -weight 0

textsh::start .textshell

set textshh ""

bind .wz <Button-1> {
global textshh textshoh hfont
%W configure -background $c(color-menuactive)
set textshh %Y
set textshoh  [expr [winfo height .textshell]-4]

# Get the height of the current font
set hfont [font metrics [.textshell cget -font] -displayof .textshell -linespace]
}

bind .wz <ButtonRelease> {
global textshh
set textshh ""
%W configure -background $c(color-background)
}

bind .wz <Enter> " %W configure -background $c(color-menuactive) "
bind .wz <Leave> " %W configure -background $c(color-background) "

bind .wz  <Motion> {
global textshh textshoh hfont c
if {$textshh!=""} {
	set w [expr ($textshoh + ($textshh -%Y)) /$hfont]
	if {$w>0} { 
	.textshell configure -height $w 
	set c(textshell-height) $w
	}
 	}
}

} else {
c "Deactivate textshell"
textsh::stop
destroy .textshell
destroy .shscrolly
destroy .shscrollx
destroy .wz
}
}

#----------------------------------------------------------

proc gbn {n} {
global c
return "([lindex [split $c($n) "|"] 0])"
}

#make window buttons

frame .wl -height 20 -relief sunken -borderwidth 0 -background $c(color-background)
bind .wl <Button-3> speed::Side

Supertext::text .text -yscrollcommand ".scrolly set"  -xscrollcommand ".scrollx set" \
-setgrid false -wrap none -background $c(color-editbg) -foreground $c(color-edittxt) \
-exportselection 0 -borderwidth 1 -highlightthickness 0  -insertbackground $c(color-cursor) \
-font $c(font-editor) -borderwidth 1

scrollbar .scrolly -command ".text yview" -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg) 
scrollbar .scrollx -command ".text xview" -orient horiz -background $c(color-menubg) -activebackground $c(color-menuactive) -troughcolor $c(color-menubg)

frame .status -borderwidth 1 -relief flat 
label .status.l1 -text "1"  -relief sunken -borderwidth 1 -width 10
label .status.l2 -text "2" -relief sunken -borderwidth 1 
label .status.filler -text "" -relief sunken -borderwidth 1
label .status.l3 -text "3" -relief sunken -borderwidth 1 -width 13 

canvas .status.c -relief sunken -borderwidth 0 -width 20 -height 16 -cursor bottom_right_corner

pack .status.l1 .status.l3 .status.l2 -side left -padx 1
pack .status.filler -side left -fill x -expand yes -padx 1
pack .status.c  -padx 1


.status.c create line 19 0   1 18 -fill white
.status.c create line 19 1   2 18 -fill gray70
.status.c create line 19 2   3 18 -fill gray70
.status.c create line 19 6   7 18 -fill white
.status.c create line 19 7   8 18 -fill gray70
.status.c create line 19 8   9 18 -fill gray70
.status.c create line 19 12   13 18 -fill white
.status.c create line 19 13   14 18 -fill gray70



#------------------------ Window resizing ------------------------------------
set zpos ""
set wpos ""

bind all  <ButtonRelease> {
global zpos
set zpos ""
}

bind .status.c <Button> {
global zpos wpos
set zpos "%X %Y"
set wpos [split [winfo geometry .] "+x"]
}

bind .status.c <Motion> {
global zpos wpos
if {$zpos!=""} {
	set diffx [expr %X - [lindex $zpos 0] ]
	set diffy [expr %Y - [lindex $zpos 1] ]

	set w [expr [lindex $wpos 0] + $diffx] 
	set h [expr [lindex $wpos 1] + $diffy]
				
	if {$w<0} { set w [lindex $wpos 0] }
	if {$h<0} { set h [lindex $wpos 1] }
	set s "x"

	if {$tcl_platform(platform)!="windows"} {
	# For X11 we need to compensate for menubar
	set menuh [winfo height .#menu]	
	wm geometry . "=$w$s$h+[winfo x .]+[expr [winfo y .] - $menuh ]"
	} else {
	wm geometry . "=$w$s$h"
	}

	}
}


#----------------------------------------------------------------

grid  .wl  -row 0 -column 0 -sticky ew -columnspan 5      
grid .text -column 0 -row 1 -sticky nsew -rowspan 2 -columnspan 3
grid .scrolly -column 3 -row 1 -sticky ns -rowspan 2
grid .scrollx -column 0 -row 3 -sticky ew -columnspan 2

grid .status -column 0 -row 7 -sticky ew -columnspan 5

grid rowconfigure . 2 -weight 3
grid columnconfigure . 3 -weight 0
grid columnconfigure . 1 -weight 2

if {$c(flist)==1} {doflist 1}
if {$c(textshell)==1} {dotextshell 1}

#------------------------------- Make menu --------------------------------
xmenu .menu

set menu .menu.file
xmenu $menu 
#-activeborderwidth 0
.menu add cascade -label "File" -underline 0 -menu $menu

set co [.menu cget -background]
.menu.file add command -image bar -columnbreak 0 -hidemargin 1 -activeforeground $co -activebackground $co -foreground $co -background $co

$menu add command -label "New file" -underline 0 -command "file::NewFile" -columnbreak 1
$menu add command -label "Open..." -accelerator [gbn key-load] -underline 0 -command "file::Load file"
$menu add command -label "Save" -accelerator [gbn key-save] -underline 0 -command { file::Save $window($current_window,info) -force }
$menu add command -label "Save As..." -accelerator [gbn key-saveas ] -underline 4 -command { file::Save $window($current_window,info) }
$menu add command -label "Save All" -accelerator [gbn key-saveall ] -underline 4 -command { file::SaveAll }

$menu add cascade -label "Recent..." -menu $menu.rcent -underline 0
xmenu $menu.rcent 
$menu add separator
$menu add cascade -label "Net" -menu $menu.netmenu -underline 2 

xmenu $menu.netmenu 
$menu.netmenu add command -label "Open URL.." -underline 5 -command "file::Load http"
$menu.netmenu  add command -label "Open FTP.." -underline 5 -command "file::Load ftp"
$menu.netmenu  add command -label "Save As FTP.." -underline 5 -command { file::Save $window($current_window,info) }
$menu add command -label "Execute" -underline 0 -command "exec::execute"
$menu add separator
$menu add command -label "Close" -accelerator [gbn key-closefile] -underline 0 -command { file::Close $current_window }
$menu add command -label "Close All" -underline 0 -command { file::CloseAll }
$menu add command -label "Exit" -accelerator [gbn key-exit] -underline 1 -command file::eexit

set menu .menu.editmenu
xmenu $menu 
.menu add cascade -label "Edit" -underline 0 -menu $menu 
$menu add command -label "Undo" -accelerator [gbn key-undo ] -underline 0 -command "txt::undo .text"
$menu add command -label "Copy" -accelerator [gbn key-copy] -underline 0 -command "txt::copy .text"
$menu add command -label "Copy from..." -accelerator [gbn key-copyfromclip ] -underline 5 -command "txt::copyfrom_clip .text"
$menu add command -label "Cut" -accelerator [gbn key-delete ] -underline 1 -command "txt::cut .text"
$menu add command -label "CopyCut" -accelerator [gbn key-copycut ] -command "txt::copycut .text"
$menu add command -label "Paste" -accelerator [gbn key-paste ] -underline 0 -command "txt::paste .text"
$menu add command -label "Select all" -accelerator [gbn key-tagall ] -underline 0 -command "txt::tagall .text"
$menu add command -label "Evaluate" -accelerator [gbn key-texteval ] -underline 0 -command "txt::texteval .text"
$menu add command -label "Special Char..." -accelerator [gbn key-specc ] -underline 0 -command {specc::specc -win ".text"}

$menu add separator
$menu add checkbutton -label "Wrap lines" -variable wraping -offvalue "none" -onvalue "word" -command { .text configure -wrap $wraping }   

set menu .menu.searchmenu
xmenu $menu 
.menu add cascade -label "Search" -underline 0 -menu $menu 
$menu add command -label "Find" -underline 0 -accelerator [gbn key-find ] -command "Find find"
$menu add command -label "Replace" -underline 0 -command "Find replace"
$menu add command -label "FindNext" -accelerator [gbn key-searchagain ] -underline 4 -command FindIt
$menu add command -label "Goto line" -underline 0 -accelerator [gbn key-goto ] -command Goto_line_ask

set menu .menu.macromenu
xmenu $menu 
.menu add cascade -label "Macro" -underline 0 -menu $menu 
set menu .menu.windowmenu
xmenu $menu 
.menu add cascade -label "Windows" -underline 0 -menu $menu      

set menu .menu.helpmenu
xmenu $menu 
.menu add cascade -label "Help" -underline 0 -menu $menu 
$menu add command -label "Help" -command "win::activate 300"
$menu add separator
$menu add command -label "About" -hidemargin 1 -command { win::activate 300; pml::inserttext .text [pml::gettopic about] }

. configure -menu .menu
.menu configure -background $c(color-menubg) -foreground $c(color-menutxt) -activebackground $c(color-menuactive) -activeforeground $c(color-menuactivetext)
