#?-Speedbuttons
#?
#? %2Abstract:%
#? Speed buttons is the buttons just below the menu bar.
#? All speed buttons is linked to a user defined macro.
#?
#? %2Adding:%
#? To add a speed button "right-click" anywhere on the speed button bar and
#? select Assign, and a list with all available macros will appear.
#? Just select the macro you want to add and a button with that macros name
#? will apear.
#?
#? %2Remove:%
#? To remove a speed button "right-click" on the speed button you want to remov
#? and select remove this.
#?
#? Related topics: %lMACROS%
#?


namespace eval speed {

namespace export Update Button Side Assign Remove Edit selIcon


proc Edit {} {
global current_button c home installdir
c $current_button
macro::edit "[lindex $c(speed) [expr $current_button - 1]]"
.mnu unpost
}


proc Remove {} {
global current_button c
c $current_button

macro::rec global current_button
macro::rec "set current_button $current_button"
macro::rec "speed::Remove"

if {$current_button!=-1} {
speed::removeIcon
set n [expr $current_button - 1]
set c(speed) [ lreplace $c(speed) $n $n]
speed::Update
}
.mnu unpost
}

proc Assign {name} {
global current_button c
c $current_button

macro::rec global current_button
macro::rec "set current_button $current_button"
macro::rec "speed::Assign $name"

if {$current_button==-1} {
set c(speed) "$c(speed) {$name}"
} else {
set n [expr $current_button - 1]
set c(speed) [ lreplace $c(speed) $n $n $name ]
}

speed::Update
.mnu unpost
}

proc selIcon {} {
global current_button c

set file [tk_getOpenFile -title "Select Icon" -filetypes "{{Gif file} {.gif}} {{All Files} {*}}"  ]

if {($current_button!=-1) && ($file!="")}  {
set n [expr $current_button - 1]
set sb [lindex $c(speed) $n]	

set ni [lsearch $c(speed-icon) $sb]
c $ni
if {$ni==-1} {
	set c(speed-icon) "$c(speed-icon) $sb $file"
	} else {
	set ni [expr $ni +1]
	set c(speed-icon) [ lreplace $c(speed-icon) $ni $ni $file ]
	}
}
c $c(speed-icon)
speed::Update
}


proc removeIcon {} {
global current_button c
if {$current_button!=-1}  {
set n [expr $current_button - 1]
set sb [lindex $c(speed) $n]	
set ni [lsearch $c(speed-icon) $sb] 
if {$ni!=-1} {
	set c(speed-icon) [ lreplace $c(speed-icon) $ni $ni]
	set c(speed-icon) [ lreplace $c(speed-icon) $ni $ni]
	c "Remove Icon for: $sb"
	}
}
}

proc Update {} {
global current_button c
c
set menu .mnu
destroy $menu
xmenu $menu 
xmenu $menu.macros

$menu add command -label "Never mind" -command "$menu unpost"
$menu add command -label "Remove this." -command "speed::Remove"
$menu add command -label "Edit this." -command "speed::Edit"
$menu add cascade -label "Icon" -menu $menu.icon
$menu add cascade -label "Assign" -menu $menu.list
xmenu $menu.icon
$menu.icon add command -label "Select icon..." -command "speed::selIcon"
$menu.icon add command -label "Remove icon" -command {
speed::removeIcon
speed::Update
}

xmenu $menu.list 

$menu configure -background $c(color-menubg) -foreground $c(color-menutxt) -activebackground $c(color-menuactive) -activeforeground $c(color-menuactivetext)

foreach n [macro::names] {
$menu.list add command -label $n -command "speed::Assign {$n}"
}

set current_button -1


#Delete all buttons within frame .wl
foreach n [winfo children .wl] {
destroy $n
}

#Add all relevant buttons to frame
set i 1
foreach n $c(speed) {

set ni [lsearch $c(speed-icon) $n]
if {$ni==-1} {
xbutton  .wl.t$i -text "$n" -command "macro::play {$n}"
} else {
image create photo "icon.$n" -file [lindex $c(speed-icon) [expr $ni+1]]
xbutton  .wl.t$i -image "icon.$n" -command "macro::play {$n}"
}

pack .wl.t$i -side left
bind .wl.t$i <Button-3> "speed::Button $i"
bind .wl.t$i <Enter> ".status.filler config -text $n"
bind .wl.t$i <Leave> {.status.filler config -text ""}

incr i
}

if {[llength $c(speed)]==0} {
label .wl.t -text "Right click here to add macro buttons" 
pack .wl.t
bind .wl.t <Button-3> speed::Side
}

}

proc Button {n} {
global current_button
set current_button $n
.mnu post [winfo pointerx . ] [winfo pointery .]
}

proc Side {} {
global current_button
set current_button -1
.mnu post [winfo pointerx . ] [winfo pointery .]
}


}

#Initialize
speed::Update



